#include "includes.h"

BITMAP *blsq, *cysq, *grsq, *pusq, *resq, *whsq, *yesq, *back, *buff, *mysq, *posq, *crsq, *bhelp;

BITMAP *pal, *qua, *poi, *t, *z, *zin, *l, *lin, *cru, *c;

SAMPLE *colide, *move, *linha, *pausar;

MIDI *musica, *gameover;

bool som = true;

int peca;

int **game_matrix;

int pontos = 0;

int ctt = 25, size = 20;

void play_pause()
{
	if(som)
		play_sample(pausar,80,128,1000,0);
}

void zera_mat()
{
	for(int i=0; i < 20; i++)
	{
		for(int j=0; j < 10; j++)
		{
			game_matrix[i][j] = 0;
		}
	}
}

void help()
{

	acquire_screen();

	show_mouse(NULL);

	draw_sprite(screen, bhelp, 0, 0);

	release_screen();

	readkey();

	acquire_screen();

	draw_sprite(screen, back, 0, 0);

	show_mouse(screen);

	release_screen();

}

void testa_pontos(int *a, int *b)
{
	
	int p = pontos/5000;
	if( p > 0 && p < 2 )
		(*a) = 10;
	else if( p >= 2 && p < 4 )
		(*a) = 6;
	else if( p >= 4 && p < 6 )
		(*a) = 4;
	else if( p >= 6 && p < 8 )
		(*a) = 2;
	else if( p >= 8 && p < 10 )
		(*a) = 1;
	else if( p >= 10 && p < 12 )
		(*b) = 60;
	else if( p >= 12 && p < 14 )
		(*b) = 45;
	else if( p >= 14 && p < 16 )
		(*b) = 30;
	else if( p >= 16 && p < 18 )
		(*b) = 15;
	else if( p >= 18 && p < 20 )
		(*b) = 10;
	else if( p >= 20 && p < 22 )
		(*b) = 5;


}

void play_colide()
{
	if(som)
		play_sample(colide,80,128,1000,0);
}

void play_move()
{
	if(som)
		play_sample(move,65,128,1000,0);
}

void play_linha()
{
	if(som)
		play_sample(linha,100,128,1000,0);
}

void atualiza()
{

	draw_sprite( buff, back, 0, 0 );

	rectfill (buff,ctt+15,ctt,240,425,makecol(0,0,0));

	int i, j;

	for ( i=0; i<20; i++)
	{
		for( j=0; j<10; j++)
		{

			if( game_matrix[i][j] == 0 )
			{
				rectfill( buff, j*20+ctt+15, i*20+ctt, j*20+ctt+15+size, i*20+ctt+size, makecol(0,0,0));
			}
			else if( game_matrix[i][j] == PALITO )
			{
				draw_sprite( buff, resq, j*20+ctt+15, i*20+ctt );
			}
			else if( game_matrix[i][j] == QUADRADO )
			{
				draw_sprite( buff, cysq, j*20+ctt+15, i*20+ctt );
			}
			else if( game_matrix[i][j] == ZINV )
			{
				draw_sprite( buff, grsq, j*20+ctt+15, i*20+ctt );
			}
			else if( game_matrix[i][j] == Z )
			{
				draw_sprite( buff, whsq, j*20+ctt+15, i*20+ctt );
			}
			else if( game_matrix[i][j] == L )
			{
				draw_sprite( buff, yesq, j*20+ctt+15, i*20+ctt );
			}
			else if( game_matrix[i][j] == LINV )
			{
				draw_sprite( buff, pusq, j*20+ctt+15, i*20+ctt );
			}
			else if (game_matrix[i][j] == T )
			{
				draw_sprite( buff, blsq, j*20+ctt+15, i*20+ctt );
			}
			else if (game_matrix[i][j] == C )
			{
				draw_sprite( buff, mysq, j*20+ctt+15, i*20+ctt );
			}	
			else if (game_matrix[i][j] == CPOINT )
			{
				draw_sprite( buff, posq, j*20+ctt+15, i*20+ctt );
			}
			else
			{
				draw_sprite( buff, crsq, j*20+ctt+15, i*20+ctt );
			}



		}
	}

	//306,351

	if(peca == 0)
	{
		draw_sprite(buff,pal,306,351);
	}
	else if(peca == 1)
	{
		draw_sprite(buff,qua,306,351);
	}
	else if(peca == 2)
	{
		draw_sprite(buff,zin,306,351);
	}
	else if(peca == 3)
	{
		draw_sprite(buff,l,306,351);
	}
	else if(peca == 4)
	{
		draw_sprite(buff,t,306,351);
	}
	else if(peca == 5)
	{
		draw_sprite(buff,lin,306,351);
	}
	else if(peca == 6)
	{
		draw_sprite(buff,z,306,351);
	}
	else if(peca == 7)
	{
		draw_sprite(buff,c,306,351);
	}
	else if(peca == 8)
	{
		draw_sprite(buff,poi,306,351);
	}
	else if(peca == 9)
	{
		draw_sprite(buff,cru,306,351);
	}

	textprintf(buff, font, 470, 353, makecol(255, 255, 255), "%i", pontos); 

	acquire_screen();

	draw_sprite( screen, buff, 0, 0 );

	release_screen();

}

void pontua()
{
	int i, j, k, l;

	int count = 0;

	int lines = 0;

	bool line = false;

	int peca_atual = 0;

	for( i = 19; i >= 0; i-- )
	{
		for( j = 0; j < 10; j++ )
		{
			if( game_matrix[i][j] != 0 )
				count++;
		}
		if(count == 10)
		{
			for( k = i; k - 1 > 0; k-- )
			{
				for( l = 0; l < 10; l++ )
				{
					game_matrix[k][l] = game_matrix[k - 1][l];
				}
			}
			for(k = 0; k < 10; k++)
			{
				game_matrix[0][k] = 0;
			}
			
			i++;

			line = true;

			lines++;
				
		}
		count = 0;

	}

	if(lines == 1)
	{
		pontos += 250;
		lines = 0;
	}
	else if (lines == 2)
	{
		pontos += 600;
		lines = 0;
	}
	else if (lines == 3)
	{
		pontos += 850;
		lines = 0;
	}
	else if( lines == 4 )
	{
		pontos += 1000;
		lines = 0;
	}

	if(line)
	{
		play_linha();
	}
}

int main(void)
{

	printf("************************************\n");
	printf("*           Falling BloX           *\n");
	printf("************************************\n\n");
	printf("\t\tpor Victor Lappas Gimenez\n\n\n");

	bool classic, continua = true, voltar = false;

	int numPecas = 7;

	int peca_atual;

	int REST;

	int loop_rest;

	int xmouse = 0, ymouse = 0;

	srand(time(NULL));

	int ind = 0;

	int x = 3, y = 0;

	game_matrix = new int*[20];

	for ( ind = 0; ind < 20; ind++ )
	{
		game_matrix[ind] = new int[20];
	}

	for (int i=0; i < 20; i++)
	{
		for (int j=0; j < 10; j++)
		{
			game_matrix[i][j] = 0;
		}
	}

	allegro_init();

	install_keyboard();

	install_timer();

	install_mouse();

	set_color_depth(24);
    
	set_gfx_mode(GFX_AUTODETECT_WINDOWED, 600, 450, 0, 0);

	set_window_title("Falling BloX - Victor Lappas Gimenez");

	if(install_sound(DIGI_AUTODETECT,MIDI_AUTODETECT,NULL) < 0)
	{
		printf("Erro ao inicializar a placa de som... O jogo rodar sem som...\n\n");
		som = false;
	}


	bhelp = load_bitmap( "Imagens/Help.bmp", NULL);
	blsq = load_bitmap( "Imagens/BlueSquare.bmp", NULL);
	cysq = load_bitmap( "Imagens/CyanSquare.bmp", NULL);
	grsq = load_bitmap( "Imagens/GreenSquare.bmp", NULL);
	pusq = load_bitmap( "Imagens/PurpleSquare.bmp", NULL);
	resq = load_bitmap( "Imagens/RedSquare.bmp", NULL);
	whsq = load_bitmap( "Imagens/WhiteSquare.bmp", NULL);
	yesq = load_bitmap( "Imagens/YellowSquare.bmp", NULL);
	back = load_bitmap( "Imagens/InitBackground.bmp", NULL);
	buff = load_bitmap( "Imagens/Background.bmp", NULL);
	mysq = load_bitmap( "Imagens/CSquare.bmp", NULL);
	posq = load_bitmap( "Imagens/PointSquare.bmp", NULL);
	crsq = load_bitmap( "Imagens/CruzSquare.bmp", NULL);
	pal = load_bitmap( "Imagens/Palito.bmp", NULL);
	qua = load_bitmap( "Imagens/Quadrado.bmp", NULL);
	poi = load_bitmap("Imagens/Point.bmp", NULL);
	t = load_bitmap("Imagens/T.bmp", NULL);
	z = load_bitmap("Imagens/Z.bmp", NULL);
	zin = load_bitmap("Imagens/Zinv.bmp", NULL);
	l = load_bitmap("Imagens/L.bmp", NULL);
	lin = load_bitmap("Imagens/Linv.bmp", NULL);
	cru = load_bitmap("Imagens/Cruz.bmp", NULL);
	c = load_bitmap("Imagens/C.bmp", NULL);


	if (!blsq || !cysq || !grsq || !pusq || !resq || !whsq || !yesq || !back || !buff || !mysq)
	{
		printf("Ou falta alguma imagem no diretorio Imagens\\ ou voce nao possui memoria suficiente para carrega-las...\n\n");
		system("pause");
		allegro_exit();
		exit(0);
	}

	if(som)
	{
		set_volume(255,255);

		colide = load_wav("Sons/colide.wav");
		linha = load_wav("Sons/linha.wav");
		move = load_wav("Sons/move.wav");
		musica = load_midi("Sons/musica.mid");
		gameover = load_midi("Sons/gameover.mid");
		pausar = load_wav("Sons/pause.wav");

		if(!colide || !linha || !move || !musica || !gameover)
		{
			printf("Verifique diretorio dos sons.\n\n");
			system("pause");
			exit(0);
		}

	}

	while(continua)
	{

		clear_keybuf();

		zera_mat();

		REST = 70;

		loop_rest = 15;

		voltar = false;

		pontos = 0;

		acquire_screen();

		draw_sprite(screen, back, 0, 0);

		show_mouse(screen);

		release_screen();

		while( true )
		{
			if(mouse_b&1)
			{	

				xmouse = mouse_x;
				ymouse = mouse_y;
				rest(100);

			}

			if(xmouse >= 29 && xmouse <= 291 && ymouse >= 305 && ymouse <= 420)
			{
				classic = true;
				numPecas = 7;
				break;
			}
			else if(xmouse >= 303 && xmouse <= 567 && ymouse >= 306 && ymouse <= 422)
			{
				classic = false;
				numPecas = 10;
				break;
			}

			else if(xmouse >= 26 && xmouse <= 85 && ymouse >= 25 && ymouse <= 85)
			{
				help();
				xmouse = 0;
				ymouse = 0;
			}

			if( key[KEY_ESC] )
			{
				allegro_exit();
				exit(0);
			}

		}

		xmouse = 0;

		ymouse = 0;

		show_mouse(NULL);

		rest(400);
		
		peca_atual = rand()%(numPecas);

		peca = rand()%(numPecas);

		CPeca **pecas = new CPeca*[numPecas];

		pecas[0] = new CPalito( x + 2, y, game_matrix, PALITO, 4 );
		pecas[1] = new CQuadrado( x + 2, y, game_matrix, QUADRADO, 4 );
		pecas[2] = new CZinv( x + 1, y, game_matrix, ZINV, 4 );
		pecas[3] = new CL( x + 1, y, game_matrix, L, 4 );
		pecas[4] = new CT( x + 1, y, game_matrix, T, 4 );
		pecas[5] = new CLinv( x + 1, y, game_matrix, LINV, 4 );
		pecas[6] = new CZ( x + 1, y, game_matrix, Z, 4 );

		if(!classic)
		{
			pecas[7] = new CC( x + 1, y, game_matrix, C, 5 );
			pecas[8] = new CPoint( x + 1, y, game_matrix, CPOINT, 1);
			pecas[9] = new CCruz( x + 1, y, game_matrix, CCRUZ, 5);
		}

		destroy_bitmap(back);

		back = load_bitmap( "Imagens/Background.bmp", NULL);

		pecas[peca_atual]->Zera_Peca();

		atualiza();

		play_midi(musica,true);

		while(!voltar)
		{

			while(!(pecas[peca_atual]->colidiu) && !voltar)
			{

				atualiza();
				
				for( int ind = 0; ind < loop_rest; ind++)
				{
					if( key[KEY_P] )
					{
						rest(200);

						stop_midi();
						play_pause();

						while(!key[KEY_P]);

						rest(200);

						play_pause();
						play_midi(musica,true);

					}
					else if( key[KEY_UP] )
					{
						pecas[peca_atual]->Rotate();

						atualiza();

						play_move();

						rest(REST);

					}
					else if( key[KEY_DOWN] )
					{
						pecas[peca_atual]->movY();

						atualiza();

						play_move();

						rest(REST);
					}
					else if( key[KEY_LEFT] )
					{
						pecas[peca_atual]->movX(-1);
						
						atualiza();

						play_move();

						rest(REST);
					}
					else if( key[KEY_RIGHT] )
					{
						pecas[peca_atual]->movX(1);

						atualiza();

						play_move();

						rest(REST);
					}
					else if(key[KEY_ESC])
					{
						allegro_exit();
						exit(0);
					}
					else if(key[KEY_BACKSPACE])
					{
						voltar = true;
						break;
					}
					else
						rest(REST);
				}

				pecas[peca_atual]->movY();
			}
			
			if(voltar)
				continue;

			play_colide();

			pontua();

			atualiza();

			rest(100);

			peca_atual = peca;

			peca = rand()%(numPecas);

			if(pecas[peca_atual]->Zera_Peca())
			{
				atualiza();
				rest(REST);
				testa_pontos(&loop_rest, &REST);
				if(loop_rest <= 1)
				{
					loop_rest = 1;
				}
			}
			else
				break;
		}

		destroy_bitmap(back);

		if(voltar)
		{
                  
            if(som)
                   stop_midi();
                   
			back = load_bitmap("Imagens/InitBackground.bmp",NULL);

			continue;
		}

		back = load_bitmap( "Imagens/GameOver.bmp", NULL);

		acquire_screen();

		draw_sprite(screen, back, 0, 0);

		show_mouse(screen);

		if(som)
		{
			stop_midi();
			play_midi(gameover,false);
		}

		release_screen();

		while(true)
		{
			if(mouse_b&1)
			{
				xmouse = mouse_x;
				ymouse = mouse_y;
			}
			if(xmouse >= 29 && xmouse <= 291 && ymouse >= 305 && ymouse <= 420)
			{
				continua = true;
				destroy_bitmap(back);
				back = load_bitmap( "Imagens/InitBackground.bmp", NULL);
				break;
			}
			else if(xmouse >= 303 && xmouse <= 567 && ymouse >= 306 && ymouse <= 422)
			{
				continua = false;
				break;
			}

			if( key[KEY_ESC] )
			{
				allegro_exit();
				exit(0);
			}
		}

		rest(600);

		show_mouse(NULL);

		xmouse = 0;

		ymouse = 0;

		

	}

	allegro_exit();
	
	return EXIT_SUCCESS;

}

END_OF_MAIN();
